/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class EquipmentContext {
    private final LivingEntity entity;
    protected final boolean[] fetchedTool = new boolean[6];
    protected final IToolStackView[] toolsInSlots = new IToolStackView[6];
    private LazyOptional<TinkerDataCapability.Holder> tinkerData = null;

    @Nullable
    protected static IToolStackView getToolStackIfModifiable(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return ToolStack.from(stack);
        }
        return null;
    }

    @Nullable
    public IToolStackView getToolInSlot(EquipmentSlot slotType) {
        int index = slotType.m_20750_();
        if (!this.fetchedTool[index]) {
            this.toolsInSlots[index] = EquipmentContext.getToolStackIfModifiable(this.entity.m_6844_(slotType));
            this.fetchedTool[index] = true;
        }
        return this.toolsInSlots[index];
    }

    public boolean hasModifiableArmor() {
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            if (!ModifierUtil.validArmorSlot(this.entity, slotType) || this.getToolInSlot(slotType) == null) continue;
            return true;
        }
        return false;
    }

    public LazyOptional<TinkerDataCapability.Holder> getTinkerData() {
        if (this.tinkerData == null) {
            this.tinkerData = this.entity.getCapability(TinkerDataCapability.CAPABILITY);
        }
        return this.tinkerData;
    }

    public EquipmentContext(LivingEntity entity) {
        this.entity = entity;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }
}

